<?php
/* Template Name: Can't Publish */ 
get_header();
?>

<?php
if ( !is_user_logged_in() ) {
    $url= get_site_url().'/login/';
   echo "<script> window.location.href ='".$url."';</script>";
}
?>
<div class="dashboard-heading">
    <h1 class="text-center">Can't Publish</h1>
    <div class="snow-blanket"></div>
</div>
<div class="container dashboard-postlists-width">  
    <div class="dashboard_posts_container">
        <div class="creator_dashboard_content">
            <div class="creator_dashboard_main_section row">
                <?php include('creator_dashboard_leftsidebar.php'); ?>
                   <div class="col-sm-8 col-md-9 rightsidebar_dashboard_content require_changes_section">
						    <h2 class="empty-state-header">Before we continue</h2>  
                            <p class="state-text">Please note that Millionaire Business Articles team reserves the right to publish or reject any post.</p>
                            <span class="guideline-text"><span> → </span> Here are some guidelines which may help you to successfully get your first article published.
                            </span> 
                            <ul class="guidline-points">
                                <li><div class="check-mark"><img src="<?php echo get_stylesheet_directory_uri(); ?>/images/dashboard-icons/tick-mark.png" alt="check-marker"></div><p>Please refrain from posting news pieces as those are done by the news team. If <span class="bold-text">you have a unique news piece </span>to share, please double check with the specific email ids given below.</p></li>
                                <li><div class="check-mark"><img src="<?php echo get_stylesheet_directory_uri(); ?>/images/dashboard-icons/tick-mark.png" alt="check-marker"></div><p>Please ensure that the post is <span class="bold-text">not plagiarised</span></p></li>
                                <li><div class="check-mark"><img src="<?php echo get_stylesheet_directory_uri(); ?>/images/dashboard-icons/tick-mark.png" alt="check-marker"></div><p>Please <span class="bold-text">refrain from any sort of fraudulent </span>ways of generating views.</p></li>
                                <li><div class="check-mark"><img src="<?php echo get_stylesheet_directory_uri(); ?>/images/dashboard-icons/tick-mark.png" alt="check-marker"></div><p>Please <span class="bold-text">refrain from using misleading titles / click-baiting titles.</p></span></li>
                                <li><div class="check-mark"><img src="<?php echo get_stylesheet_directory_uri(); ?>/images/dashboard-icons/tick-mark.png" alt="check-marker"></div><p>Please <span class="bold-text">pick unique titles</span> and story ideas. If you submit an article on a topic that has already been published, your chances of getting published would reduce drastically.</p></li>
                                <li><div class="check-mark"><img src="<?php echo get_stylesheet_directory_uri(); ?>/images/dashboard-icons/tick-mark.png" alt="check-marker"></div><p>Please <span class="bold-text">don't submit any press release or promotional article</span>. If you are working with an SEO company, PR company or a marketing agency, there is a good chance your article will not be published. If you wish any such article to be published, please go to the 'Contact us' page and reach out to the sales team.</p></li>
                                <li><div class="check-mark"><img src="<?php echo get_stylesheet_directory_uri(); ?>/images/dashboard-icons/tick-mark.png" alt="check-marker"></div><p><span class="bold-text">If you wish to coordinate with the team </span>to double check for any title you can email the respective teams.</p></li>
                                <li><div class="check-mark"><img src="<?php echo get_stylesheet_directory_uri(); ?>/images/dashboard-icons/tick-mark.png" alt="check-marker"></div>Contact For Email : <p><a href="mailto:<?php echo get_option( 'admin_email' ); ?>"><?php echo get_option( 'admin_email' ); ?></a></p> </li>
                            </ul>
                            <div class="create_your_post">
                             <div class="create_your_heading">
                                <h3>Ready?<br>Create your first</h3>
                             </div>
                             <div class="create_artical">
                                <a href="<?php echo site_url(); ?>/creator/create-new/">
                                   <div class="create_button-span">
                                      <img src="<?php echo get_stylesheet_directory_uri(); ?>/images/dashboard-icons/document.png" alt="article-marker">
                                      <span>Create Article</span>
                                   </div>
                                   </a> 
                             </div>
                               
                            </div>
						    </div> 
                
            </div>
        </div>
    </div>
</div>
<?php
get_footer();
?>